# Disco Mod for RPG Maker VX Ace
# Version 1.3
# Toggle debug mode by setting `disco_debug` to true or false
$disco_debug = false

# Toggle full disco mode by setting `$full_disco` to true or false
# When true, all enemies will have randomized hues, regardless of their base hue
$full_disco = false

# Add a setter for `battler_hue` to the Game_Enemy class
class Game_Enemy
  attr_writer :battler_hue
end

class Game_Troop
  alias patch_disco_mod setup
  def setup(troop_id)
    # Call the original setup method
    patch_disco_mod(troop_id)

    # Iterate through each enemy in the troop
    @enemies.each do |enemy|
      # Check if full disco mode is enabled OR if the enemy has a non-zero hue
      if $full_disco || enemy.battler_hue != 0
        # Generate a random hue between 15 and 345
        new_hue = 15 + rand(331)

        # Debug output if enabled
        if $disco_debug
          p "Enemy #{enemy.enemy.name} (ID: #{enemy.enemy.id})"
          p "Original hue: #{enemy.battler_hue}"
          p "New hue: #{new_hue}"
        end

        # Set the new hue
        enemy.battler_hue = new_hue
      end
    end
  end
end